DROP PROCEDURE IF EXISTS sp_getGraficaMontosMes;

delimiter $
CREATE DEFINER=`root`@`localhost` PROCEDURE sp_getGraficaMontosMes(
	IN p_anio INT)
BEGIN
	DECLARE p_ultimoMesCompras int;
    DECLARE p_ultimoMesVentas int;
    DECLARE p_ultimoMesGastos int;
    
    SET p_ultimoMesCompras = (SELECT MAX( MONTH(fechaEnvio) ) FROM ORDEN_COMPRA WHERE YEAR(fechaEnvio) = p_anio);
    SET p_ultimoMesVentas = (SELECT MAX( MONTH(fecha_emision) ) FROM DOCUMENTO_VENTA WHERE YEAR(fecha_emision) = p_anio);
    SET p_ultimoMesGastos = (SELECT MAX( MONTH(fecha) ) FROM GASTO WHERE YEAR(fecha) = p_anio);

	CREATE TEMPORARY TABLE COMPRAS_TEMP AS (
	SELECT 
		month(OC.fechaEnvio) as mes, 	
		SUM(DOC.monto) as montoCompras
	FROM ORDEN_COMPRA OC 
	INNER JOIN DETALLE_ORDEN DOC ON DOC.idOrdenCompra = OC.idOrdenCompra
	WHERE YEAR(OC.fechaEnvio) = p_anio
	GROUP BY month(OC.fechaEnvio)
	ORDER BY mes);

	CREATE TEMPORARY TABLE VENTAS_TEMP AS (
	SELECT 
		month(DV.fecha_emision) as mes, 	
		SUM(DDV.precio_total) as montoVentas
	FROM DOCUMENTO_VENTA DV
	INNER JOIN DETALLE_DOCUMENTO_VENTA DDV ON DV.id = DDV.documento_venta_id
	WHERE YEAR(DV.fecha_emision) = p_anio
	GROUP BY month(DV.fecha_emision)
	ORDER BY mes);
    
    CREATE TEMPORARY TABLE GASTOS_TEMP	 AS (
	SELECT 
		month(G.fecha) as mes,
		SUM(G.monto*G.tipo_cambio) as montoGastos
	FROM GASTO G
	WHERE YEAR(G.fecha) = p_anio
	GROUP BY month(G.fecha)
	ORDER BY mes);

	SELECT M.codigo, M.nombre, 
		CASE WHEN p_ultimoMesCompras >= M.codigo THEN IFNULL(C.montoCompras, 0) ELSE C.montoCompras END as montoCompras, 
		CASE WHEN p_ultimoMesVentas >= M.codigo THEN IFNULL(V.montoVentas, 0) ELSE V.montoVentas END as montoVentas,
		CASE WHEN p_ultimoMesGastos >= M.codigo THEN IFNULL(G.montoGastos, 0) ELSE G.montoGastos END as montoGastos
	FROM MES M
	LEFT JOIN COMPRAS_TEMP C ON C.mes = M.codigo
	LEFT JOIN VENTAS_TEMP V ON V.mes = M.codigo
	LEFT JOIN GASTOS_TEMP G ON G.mes = M.codigo
	ORDER BY M.codigo;

	DROP TEMPORARY TABLE COMPRAS_TEMP;
	DROP TEMPORARY TABLE VENTAS_TEMP;

END
$